# 背景

本项目提供一种使用c/c++代码开发WMB Function Block，并加载到WMB中使用的方式。

通过pybind11将c/c++代码封装为python模块，然后通过python-fb方式封装成WMB Function Block。

因此本项目只包括将c/c++代码封装成为python模块的部分。将python代码封装成WMB Function Block请参考 [FB-Python-Template](https://code.siemens.com/wmb-devkit-group/fb-python-template)。

本项目仅提供了pybind11的部分用法，更多关于pybind11的内容，请参考 [pybind11](https://pybind11.readthedocs.io/en/stable/index.html)。

# 安装

1. cmake >= 3.4.0。
2. Windows下MSVC（Microsoft Visual Studio） >= VS2017，Linux下gcc >= 4.8。

# 使用

在template目录中提供了一个将c/c++代码封装成python模块的cmake样例工程。

## 编译

在template目录下编译工程

```shell
$ mkdir build           //创建构建目录
$ cd build
$ cmake ..              //执行cmake
```

1. Windows下

   在cmake构建成功后，会在build目录下生成对应的VS工程。可以通过Virtual Studio直接打开该工程进行编译。也可以按照下面方式利用msbuild通过命令行完成编译。

   1. 将msbuild.exe的路径添加到系统路径下。msbuild.exe的通常路径位于C:\Program Files (x86)\Microsoft Visual Studio\2019\Professional\MSBuild\Current\Bin下。
   2. 编译代码

   ```shell
   $ msbuild sample.sln
   ```

   完成编译后，在build/Debug或build/Release目录下会生成对应的.pyd文件，即可被python代码调用的python模块，以及其依赖的库文件dependent.dll。

2. Linux下

   ```shell
   $ make              //编译代码
   ```

   完成编译后，在build目录下会生成对应的.so文件，即可被python代码调用的python模块。

## 部署

1. Windows下

   将生成的.pyd文件拷贝到python fb代码中的对应目录下，然后集成到python fb中。

   当c/c++的代码有依赖第三方动态库（.dll文件）时，例如样例中生成的dependent.dll，将依赖的库文件放到.pyd文件的目录下即可。

2. Linux下

   将生成的.so文件拷贝到python fb代码中的对应目录下，然后集成到python fb中。

   当c/c++的代码有依赖第三方动态库（.so文件）时，例如样例中生成的libdependent.so可以通过下面的方法将动态库添加到spidr所在的系统中。

   ```shell
   $ mkdir /usr/wmb/lib                                            //创建存放动态库的路径
   $ cp libdependent.so /usr/wmb/lib                               //将动态库拷贝到路径下
   $ touch /etc/ld.so.conf.d/wmb.conf                               //创建动态库加载配置文件
   $ echo "/usr/wmb/lib" >> /etc/ld.so.conf.d/wmb.conf             //将动态库路径添加到配置文件
   $ ldconf                                                        //加载文件路径
   ```

   

