"""
This spidr_communicator.py is generated by FB Devkit. This file contains the FB and spidr communication mechanism.
Please do not modify this file.
"""
import sys
import json

def get_datain(key):
    """
    Parse the json string and get the corresponding key value by key
    @params
        key string - creem workflow xml element <cm:Input>
    @returns
        param[key] - parameter value of input key, type can be list, int, float, string, dict etc..
    """

    param = json.loads(sys.argv[1])
    if key in param:
        return param[key]

def get_input1():
    
    """
    Get the parameter value corresponding to input1
    @returns
        input1 - str type
    """
    
    
    input1: str = json.loads(get_datain('input1'))
    return input1


def get_input2():
    
    """
    Get the parameter value corresponding to input2
    @returns
        input2 - bool type
    """
    
    
    input2: bool = json.loads(get_datain('input2'))
    return input2


def send_output1(output1):
    """
    Send status as output
    @params
        output1 - bool type
    """
    
    output = dict()
    output["output.output1"] = json.dumps(output1)
    print(json.dumps(output))

def send_status(status):
    """
    Send status as output
    @params
        status - str type
    """
    
    output = dict()
    output["output.status"] = json.dumps(status)
    print(json.dumps(output))


def update_state(machine_state):
    print(json.dumps({"result.state":machine_state}))


# Get param input instance in spidr communicator
def get_param_input():
    return ParamInput()


# Get param output instance in spidr communicator
def get_param_output():
    return ParamOutput()


# The parameter input class, all input parameter can get here
class ParamInput():

    def __init__(self):
        self.input1 = get_input1()
        self.input2 = get_input2()


# The parameter output class, all output parameter can set here
class ParamOutput():

    def __init__(self):
        self.output1 = None
        self.status = None

    def send_to_spidr(self):
        send_output1(self.output1)
        send_status(self.status)
