"""
This spidr_communicator.py is generated by FB Devkit. This file contains the FB and spidr communication mechanism.
Please do not modify this file.
"""
import sys
import json

def get_datain(key):
    """
    Parse the json string and get the corresponding key value by key
    @params
        key string - creem workflow xml element <cm:Input>
    @returns
        param[key] - parameter value of input key, type can be list, int, float, string, dict etc..
    """

    param = json.loads(sys.argv[1])
    if key in param:
        return param[key]

def get_URL():
    
    """
    Get the parameter value corresponding to URL
    @returns
        URL - str type
    """
    
    
    URL: str = json.loads(get_datain('URL'))
    return URL


def get_httpCommand():
    
    """
    Get the parameter value corresponding to httpCommand
    @returns
        httpCommand - str type
    """
    
    
    httpCommand: str = json.loads(get_datain('httpCommand'))
    return httpCommand


def get_sendData():
    
    """
    Get the parameter value corresponding to sendData
    @returns
        sendData - str type
    """
    
    
    sendData: str = json.loads(get_datain('sendData'))
    return sendData


def get_timeout():
    
    """
    Get the parameter value corresponding to timeout
    @returns
        timeout - int type
    """
    
    
    timeout: int = json.loads(get_datain('timeout'))
    return timeout


def send_recvData(recvData):
    """
    Send status as output
    @params
        recvData - str type
    """
    
    output = dict()
    output["output.recvData"] = json.dumps(recvData)
    print(json.dumps(output))

def send_status(status):
    """
    Send status as output
    @params
        status - str type
    """
    
    output = dict()
    output["output.status"] = json.dumps(status)
    print(json.dumps(output))


def update_state(machine_state):
    print(json.dumps({"result.state":machine_state}))


# Get param input instance in spidr communicator
def get_param_input():
    return ParamInput()


# Get param output instance in spidr communicator
def get_param_output():
    return ParamOutput()


# The parameter input class, all input parameter can get here
class ParamInput():

    def __init__(self):
        self.URL = get_URL()
        self.httpCommand = get_httpCommand()
        self.sendData = get_sendData()
        self.timeout = get_timeout()


# The parameter output class, all output parameter can set here
class ParamOutput():

    def __init__(self):
        self.recvData = None
        self.status = None

    def send_to_spidr(self):
        send_recvData(self.recvData)
        send_status(self.status)
