"""
This spidr_communicator.py is generated by FB Devkit. This file contains the FB and spidr communication mechanism.
Please do not modify this file.
"""
import sys
import json

def get_datain(key):
    """
    Parse the json string and get the corresponding key value by key
    @params
        key string - creem workflow xml element <cm:Input>
    @returns
        param[key] - parameter value of input key, type can be list, int, float, string, dict etc..
    """

    param = json.loads(sys.argv[1])
    if key in param:
        return param[key]

def get_resource():
    
    """
    Get the parameter value corresponding to resource
    @returns
        resource - dict type
    """
    
    
    resource: dict = json.loads(get_datain('resource'))
    return resource


def get_waypoints():
    
    """
    Get the parameter value corresponding to waypoints
    @returns
        waypoints - list type
    """
    
    
    waypoints: list = json.loads(get_datain('waypoints'))
    return waypoints


def get_speed():
    
    """
    Get the parameter value corresponding to speed
    @returns
        speed - float type
    """
    
    
    speed: float = json.loads(get_datain('speed'))
    return speed


def get_blending():
    
    """
    Get the parameter value corresponding to blending
    @returns
        blending - float type
    """
    
    
    blending: float = json.loads(get_datain('blending'))
    return blending


def send_status(status):
    """
    Send status as output
    @params
        status - str type
    """
    
    output = dict()
    output["output.status"] = json.dumps(status)
    print(json.dumps(output))


def update_state(machine_state):
    print(json.dumps({"result.state":machine_state}))


# Get param input instance in spidr communicator
def get_param_input():
    return ParamInput()


# Get param output instance in spidr communicator
def get_param_output():
    return ParamOutput()


# The parameter input class, all input parameter can get here
class ParamInput():

    def __init__(self):
        self.resource = get_resource()
        self.waypoints = get_waypoints()
        self.speed = get_speed()
        self.blending = get_blending()


# The parameter output class, all output parameter can set here
class ParamOutput():

    def __init__(self):
        self.status = None

    def send_to_spidr(self):
        send_status(self.status)
