from enum import Enum


class StatusCode(Enum):
    """
    Sample status code.
    For FB output parameters, StatusCode(string type) is a default one, which means the FB execution result.
    We recommend FB developers to use following rules to define status code:
    1. "Good" if FB runs successfully.
    2. "Bad" for default if FB runs failed.
    3. Start with "Bad" to define specific error codes, such as "BadRobotMoveError" etc.
    """
    GOOD = (0, 'Good')
    BAD = (-1, 'Bad')
    BAD_INVALID_ARGUMENT = (100, "BadInvalidArgument")
    BAD_COMMUNICATION_ERROR = (200, "BadCommunicationError")
    BAD_ROBOT_MOVE_ERROR = (300, 'BadRobotMoveError')

    @property
    def code(self):
        """code"""
        return self.value[0]

    @property
    def msg(self):
        """message"""
        return self.value[1]
