
"""
Test file for main.py
Version 0.1

Call this file, just use command `python test_main.py`
if need to run command, to call main.py directly, can update test_main.py parameters and run
"""


import json
import sys
from main import main_func

# Initial parameters here
resource = {"IPAddress": "192.168.1.10", "Port": 8899}
waypoints = [
    {
        "pose": {
             "x": -200,
             "y": 300,
             "z": 200,
             "rx": 3.14,
             "ry": 0,
             "rz": 1.7
        },
        "tool": {
             "name": "FlangeCenter",
             "x": 0,
             "y": 0,
             "z": 0,
             "rx": 0,
             "ry": 0,
             "rz": 0
        },
        "reference": {
             "name": "Base",
             "x": 0,
             "y": 0,
             "z": 0,
             "rx": 0,
             "ry": 0,
             "rz": 0
        }
    },
    {
        "pose": {
             "x": -200,
             "y": 300,
             "z": 500,
             "rx": 3.14,
             "ry": 0,
             "rz": 1.7
        },
        "tool": {
             "name": "Gripper1",
             "x": 0,
             "y": 0,
             "z": 200,
             "rx": 0,
             "ry": 0,
             "rz": 0
        },
        "reference": {
             "name": "Coord1",
             "x": -10,
             "y": 10,
             "z": 0,
             "rx": 0,
             "ry": 0,
             "rz": 0
        }
    }
]
speed = 50
blending = 30

# Compose args_json here
args_json = {
    "resource": json.dumps(resource),
    "waypoints": json.dumps(waypoints),
    "speed": json.dumps(speed),
    "blending": json.dumps(blending)
}

sys.argv.append(json.dumps(args_json))
main_func()
