"""
Main
Version 0.1

This main.py is generated by FB Devkit. This file contains the FB runtime mechanism. Please do not modify this file.
"""
import traceback
from spidr_communicator import update_state, get_param_input, get_param_output  
from template_system_delay import TemplateSystemDelay

from setup_log import setup_log
setup_log()

def main_func():
    # Main logic here
    machine_state = "Idle"
    update_state(machine_state)
    fb_instance = None
    try:
        param_input = get_param_input()
        param_output = get_param_output()
        
        fb_instance = TemplateSystemDelay("TemplateSystemDelay", param_input, param_output)
        
        machine_state = "Running"
        update_state(machine_state)
        
        fb_instance.run()
        param_output.send_to_spidr()

        
        if fb_instance.is_state_turn_to_fail():
            machine_state = "Fail"
        else:
            machine_state = "Success"
        update_state(machine_state)
        
    except Exception as e:
        print("Run function meet exception", e)
        traceback.print_exc()
        if fb_instance is not None and fb_instance.is_state_turn_to_success is not None:
            if fb_instance.is_state_turn_to_success(e):
                machine_state = "Success"
            else:
                machine_state = "Fail"
        else:
            machine_state = "Fail"
        update_state(machine_state)


if __name__ == '__main__':
    main_func()

