"""
FB Logic Class
Version 0.1

This file is generated by FB Devkit. Should add FB logic here.
"""
import logging
from spidr_communicator import ParamInput, ParamOutput
import time


class TemplateSystemDelay:

    def __init__(self, name: str, param_input: ParamInput, param_output: ParamOutput):
        """
        This function will be called by main.py, is the initial method of this FB
        If you have a input parameter name "newvalue", you can get it by self.param_input.newvalue
        If you want to set a output parameter name "status", you can set it by self.param_output.status = "Good"
        """
        self.name = name
        self.param_input = param_input
        self.param_output = param_output
        
        # Here is the second layer of parameter analysis, which can be customized

    def run(self):
        """
        This function will be called by main.py, is the main method of this FB
        """
        logging.info("Run function start")
        print("Delay start: {}".format(time.strftime("%Y-%m-%d %H:%M:%S", time.localtime())))
        time.sleep(self.param_input.duration)
        print("Delay {}s".format(self.param_input.duration))
        print("Delay end:   {}".format(time.strftime("%Y-%m-%d %H:%M:%S", time.localtime())))

    def is_state_turn_to_fail(self):
        """
        This method will be called by main.py
        It's a hook in running block before send machine state success, has the opportunity to set machine state as fail
        """
        return False

    def is_state_turn_to_success(self, exception):
        """
        This method will be called by main.py
        It's a hook in exception handling block before send machine state fail, has the opportunity to set machine state
        as success
        """
        return True
