import logging
import random


class GripperComm:
    """This is a sample for gripper communication class"""
    def __init__(self, device_info):
        self.ip = device_info.get("IPAddress", "127.0.0.1")
        self.port = device_info.get("Port", 5432)
        self.connected = False

    def connect(self):
        logging.info("Connect to gripper [{}:{}]".format(self.ip, self.port))
        self.connected = True
        return True

    def disconnect(self):
        logging.info("Disconnect gripper [{}:{}]".format(self.ip, self.port))
        self.connected = False

    def is_connected(self):
        return self.connected

    def calibration(self):
        logging.info("Gripper calibration")
        return True

    def grasp(self, position, force, speed):
        logging.info("Gripper grasp with position: {} force: {} speed: {}".format(position, force, speed))
        return True

    def release(self, position, force, speed):
        logging.info("Gripper release with position: {} force: {} speed: {}".format(position, force, speed))
        return True

    def get_width(self):
        # generate random width in [0, 100]
        random_width = random.randint(0, 100)
        logging.info("Gripper width: {}".format(random_width))
        return random_width
